library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;

entity arithm_block is
        generic(n:integer := 16);   
    Port ( clk : in STD_LOGIC;
           --start : in STD_LOGIC;
          -- t_finish : in STD_LOGIC;
	       smand0 : in STD_LOGIC_VECTOR(n-1 downto 0);
	       smand1 : in STD_LOGIC_VECTOR(n-1 downto 0);
	       smand2 : in STD_LOGIC_VECTOR(n-1 downto 0);
	       smand3 : in STD_LOGIC_VECTOR(n-1 downto 0);
		adder_enable : in STD_LOGIC;
	       val_out : out STD_LOGIC_VECTOR(2*n-1 downto 0));
end arithm_block;

architecture behavior of arithm_block is
  type STATES is (IDLE,STORE,COMPARE);
  type VALINDS is array (0 to 2) of integer;
  signal state : STATES := IDLE;
  signal valind : integer := 0;
  signal resig : std_logic;
  signal psum1 : signed(n downto 0):=(others => '0'); --change if decimating squared signal
  signal psum2 : signed(n downto 0):=(others => '0'); --change if decimating squared signal
  signal psum3 : signed(n+1 downto 0):=(others => '0'); --change if decimating squared signal
  signal sq : signed(2*n+3 downto 0):=(others => '0'); --change if decimating squared signal


begin
  process (clk) 
    variable j : integer := 0;
    variable k : integer := 0; 
	
  begin
    if (rising_edge(clk)) then
        if adder_enable='1' then
		psum1<=signed(smand0)+signed(smand1);
		psum2<=signed(smand2)+signed(smand3);
		psum3<=psum1+psum2;
		sq<=psum3*psum3;
		val_out<=std_logic_vector(sq(2*n+3 downto 4));
	end if;
    end if;
  end process;
end behavior;


